#include "crt.bi"
#include "fbgfx.bi"
#include  "GL/gl.bi"
#include  "GL/glu.bi"

'::::::::
Sub screen_init _
        ( _
                Byval w As Integer, _
                Byval h As Integer _
        )
        
        screenres w, h, 32, , FB.GFX_OPENGL Or FB.GFX_MULTISAMPLE ' or FB.GFX_FULLSCREEN
        
        glViewport( 0, 0, w, h )
        glMatrixMode( GL_PROJECTION )
        glLoadIdentity( )
        gluPerspective( 45, w / h, 1, 200 )
        glMatrixMode( GL_MODELVIEW )
        glLoadIdentity( )
        glShadeModel( GL_SMOOTH )
        glClearColor( 0.0, 0.0, 0.0, 1.0 )
        glClearDepth( 1.0 )
        glEnable( GL_DEPTH_TEST )
        glDepthFunc( GL_LEQUAL )
        glEnable( GL_COLOR_MATERIAL )
    glEnable( GL_TEXTURE_2D )
    glBlendFunc( GL_SRC_ALPHA,GL_ONE )
        glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST )

End Sub

Type point3d
        x As Double
        y As Double
        z As Double
End Type

Operator + _
        ( _
                Byref lhs As point3d, _
                Byref rhs As point3d _
        ) As point3d

        Operator = Type(lhs.x + rhs.x, lhs.y + rhs.y, lhs.z + rhs.z)

End Operator

Operator - _
        ( _
                Byref lhs As point3d, _
                Byref rhs As point3d _
        ) As point3d

        Operator = Type(lhs.x - rhs.x, lhs.y - rhs.y, lhs.z - rhs.z)

End Operator

Operator / _
        ( _
                Byref lhs As point3d, _
                Byref rhs As Integer _
        ) As point3d

        Operator = Type(lhs.x / rhs, lhs.y / rhs, lhs.z / rhs)

End Operator

Type pyramid_list_fwd As pyramid_list

Type pyramid
        A As point3d
        B As point3d
        C As point3d
        D As point3d
        origin As point3d
        Declare Constructor _
                ( _
                )
        Declare Constructor _
                ( _
                        Byval origin As point3d, _
                        Byval size As Double _
                )
        Declare Sub Draw _
                ( _
                )
        Declare Function split _
                ( _
                ) As pyramid_list_fwd Ptr
End Type

Type pyramid_list
        A As pyramid Ptr
        B As pyramid Ptr
        C As pyramid Ptr
        D As pyramid Ptr
        Declare Sub Draw _
                ( _
                )
End Type

Const pi As Double = Atn( 1 ) * 4

'::::::::
Function small_dist _
        ( _
                Byval size As Double _
        ) As Double

        #define D2R(a) ((a) * ((PI) / 180))

        Function = -size * Sin( D2R( 210 ) )

End Function

'::::::::
Function big_dist _
        ( _
                Byval size As Double _
        ) As Double

        #define D2R(a) ((a) * ((PI) / 180))

        Function = -size * Cos( D2R( 210 ) )

End Function

Constructor pyramid _
        ( _
        )

        A = Type(0, 0, 0)
        B = Type(0, 0, 0)
        C = Type(0, 0, 0)
        D = Type(0, 0, 0)

End Constructor

Constructor pyramid _
        ( _
                Byval _origin_ As point3d, _
                Byval size As Double _
        )

        origin = _origin_
        A = Type(0, size, 0)
        B = Type(0, -small_dist( size ), -size)
        C = Type(big_dist( size ), -small_dist( size ), small_dist( size ))
        D = Type(-big_dist( size ), -small_dist( size ), small_dist( size ))

End Constructor

Dim Shared As Double axisx, axisy, axisz

Sub pyramid.draw _
        ( _
        )

        glLoadIdentity( )
        gluLookAt 0, 4, 10, 0, 0, 0, 0, 1, 0
        glTranslatef( origin.x, origin.y, origin.z )
        glRotatef( axisx, 1, 0, 0 )
        glRotatef( axisy, 0, 1, 0 )
        glRotatef( axisz, 0, 0, 1 )

        glBegin GL_TRIANGLES
                glColor3f 1.0, 0.0, 0.0
                glVertex3f A.x, A.y, A.z
                glVertex3f B.x, B.y, B.z
                glVertex3f C.x, C.y, C.z
                glColor3f 0.0, 1.0, 0.0
                glVertex3f A.x, A.y, A.z
                glVertex3f B.x, B.y, B.z
                glVertex3f D.x, D.y, D.z
                glColor3f 0.0, 0.0, 1.0
                glVertex3f A.x, A.y, A.z
                glVertex3f C.x, C.y, C.z
                glVertex3f D.x, D.y, D.z
                glColor3f 1.0, 0.0, 1.0
                glVertex3f B.x, B.y, B.z
                glVertex3f C.x, C.y, C.z
                glVertex3f D.x, D.y, D.z
        glEnd

End Sub

Function pyramid.split _
        ( _
        ) As pyramid_list Ptr

        Dim pl As pyramid_list Ptr = callocate( sizeof( pyramid_list ) )

                pl->A = callocate( sizeof( pyramid ) )
                pl->A->A = A
                pl->A->B = ((A - B) / 2) + B
                pl->A->C = ((A - C) / 2) + C
                pl->A->D = ((A - D) / 2) + D
                pl->A->origin = origin

                pl->B = callocate( sizeof( pyramid ) )
                pl->B->A = ((A - B) / 2) + B
                pl->B->B = B
                pl->B->C = ((B - C) / 2) + C
                pl->B->D = ((B - D) / 2) + D
                pl->B->origin = origin

                pl->C = callocate( sizeof( pyramid ) )
                pl->C->A = ((A - C) / 2) + C
                pl->C->B = ((B - C) / 2) + C
                pl->C->C = C
                pl->C->D = ((C - D) / 2) + D
                pl->C->origin = origin

                pl->D = callocate( sizeof( pyramid ) )
                pl->D->A = ((A - D) / 2) + D
                pl->D->B = ((B - D) / 2) + D
                pl->D->C = ((D - C) / 2) + C
                pl->D->D = D
                pl->D->origin = origin

                Function = pl

End Function

Sub pyramid_list.draw _
        ( _
        )

        A->draw( )
        B->draw( )
        C->draw( )
        D->draw( )

End Sub

Sub pyramid_draw( Byval depth As Integer, Byval p As pyramid Ptr )

        Dim As pyramid_list Ptr pl
                
                If depth = 0 Then
                        p->draw( )
                Else
                        pl = p->split
                        pyramid_draw( depth - 1, pl->A )
                        pyramid_draw( depth - 1, pl->B )
                        pyramid_draw( depth - 1, pl->C )
                        pyramid_draw( depth - 1, pl->D )
                        deallocate( pl->A )
                        deallocate( pl->B )
                        deallocate( pl->C )
                        deallocate( pl->D )
                        deallocate( pl )
                End If

End Sub

Sub screen_draw _
        ( _
        )

        Dim As pyramid p1 = pyramid( type<point3d>(0, 0, 0), 3 )
        Dim As pyramid_list Ptr pl(0 To 21)

                glClear( GL_COLOR_BUFFER_BIT Or GL_DEPTH_BUFFER_BIT )

                pyramid_draw( 4, @p1 )

                glFlush( )

End Sub

        screen_init( 800, 600 )

        While Not multikey( fb.sc_escape )
                screen_draw( )
                flip( )
                If multikey( fb.sc_w ) Then axisx -= 0.4
                If multikey( fb.sc_s ) Then axisx += 0.4
                If multikey( fb.sc_a ) Then axisy -= 0.4
                If multikey( fb.sc_d ) Then axisy += 0.4
                If multikey( fb.sc_z ) Then axisz -= 0.4
                If multikey( fb.sc_x ) Then axisz += 0.4
        Wend
 
